import matplotlib.pyplot as plt

def draw(
        values:list
):
    bar_width = 0.4
    offset = 9

    positions = []
    for i in range(3):
        for j in range(10):
            positions.append((i+1)*offset-3*bar_width+j*2*bar_width)


    color = ['#008000', '#F0E68C', '#808080','#000080' ,'#ADD8E6','#D2B48C','#808000','#DAA520','#C1F80A','#D2691E']
    plt.bar(positions, values, color=color, edgecolor='black', linewidth=2)

    legend_labels = ['OWA', 'R', 'Ada','GOK','EAE','UCB','MOT','MPC', 'S-OWA','A-OWA']
    legend_handles = [plt.Line2D([0], [0], color=color, linewidth=3, linestyle='-') for color in
                      color]
    plt.legend(legend_handles, legend_labels, loc='upper center', bbox_to_anchor=(0.5, 1.15),
               fancybox=True, shadow=True, ncol=5, fontsize=10)

    plt.xlabel(r"$K$ (kJ)", fontsize=12)
    plt.ylabel(r"Accumulated Accuracy", fontsize=12)

    plt.grid(axis='y', linestyle='--', alpha=0.7)

    plt.xticks([(i+1.275)*offset for i in range(3)], ['4', '5', '6'],fontsize=10)
    figure = plt.gcf()
    figure.savefig("Set2-1.pdf")
    plt.show()

if __name__ == '__main__':
    OWA = [120.75527550956308, 0, 144.2564142111998, 0, 0, 147.1598958944579]
    Random = [117.68741696453658, 0, 112.02520803092361, 0, 0, 112.57203884284516]
    Adaptive = [55.48041048383349, 0, 64.81867735419044, 0, 0.0, 88.49216046359132]
    SingleOLS = [94.33870203596943,0, 102.41128834917671, 0, 0.0, 131.55498334569864]
    MAB = [57.50369477736122, 0, 57.50369477736122, 0, 0.0, 57.50369477736122]
    GOK = [65.69744160457869, 0, 65.69744160457869, 0.0, 0.0, 65.69744160457869]
    MPC = [65.69744160457869, 0, 90.69162698071572, 0.0, 0.0, 115.68581235685278]
    UBC = [114.59474264908765, 0, 114.59474264908765, 0.0, 0.0, 114.59474264908765]
    AvgM = [30.415125805984367, 0, 30.377585021087945, 0.0, 0.0, 31.119236378791243]
    OTP = [93.07551125132048,0,111.8176330189531,0.0,0.0,140.9139314210841]
    rows = [OWA, Random, Adaptive, GOK, MAB, UBC, OTP, MPC, SingleOLS, AvgM]
    data = []
    for j in range(3):
        if j==0:
            for i in rows:
                data.append(i[0])
        if j==2:
            for i in rows:
                data.append(i[-1])
        if j==1:
            for i in rows:
                data.append((i[2]+i[3])/2)
    print(len(data))
    draw(data)